/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.events;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2complements.content.feature.EntityFeature;
import dev.xkmc.l2complements.events.event.EnderPickupEvent;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericArmorItem;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericTieredItem;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="l2complements", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpecialEquipmentEvents {
    public static ThreadLocal<Stack<Pair<ServerPlayer, BlockState>>> PLAYER = ThreadLocal.withInitial(Stack::new);

    public static boolean isVisible(LivingEntity entity, ItemStack stack) {
        if (entity.m_20145_()) {
            GenericTieredItem item;
            Item item2 = stack.m_41720_();
            if (item2 instanceof GenericTieredItem && (item = (GenericTieredItem)item2).getExtraConfig().hideWithEffect()) {
                return false;
            }
            item2 = stack.m_41720_();
            if (item2 instanceof GenericArmorItem && (item = (GenericArmorItem)item2).getConfig().hideWithEffect()) {
                return false;
            }
            return stack.getEnchantmentLevel((Enchantment)LCEnchantments.SHULKER_ARMOR.get()) == 0;
        }
        return true;
    }

    public static int blockSound(ItemStack stack) {
        GenericArmorItem item;
        Item item2 = stack.m_41720_();
        if (item2 instanceof GenericArmorItem && (item = (GenericArmorItem)item2).getConfig().dampenVibration()) {
            return 1;
        }
        return stack.getEnchantmentLevel((Enchantment)LCEnchantments.DAMPENED.get());
    }

    private static ItemStack process(Level level, ItemStack stack) {
        ItemStack input = stack.m_41777_();
        SimpleContainer cont = new SimpleContainer(new ItemStack[]{input});
        Optional opt = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)cont, level);
        if (opt.isPresent()) {
            ItemStack ans = ((SmeltingRecipe)opt.get()).m_5874_((Container)cont, level.m_9598_());
            int count = ans.m_41613_() * input.m_41613_();
            ans.m_41764_(count);
            return ans;
        }
        return stack;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDrop(LivingDropsEvent event) {
        LivingEntity player;
        Object object = event.getSource().m_7639_();
        if (object instanceof LivingEntity && (player = (LivingEntity)object).m_21205_().getEnchantmentLevel((Enchantment)LCEnchantments.SMELT.get()) > 0) {
            object = event.getDrops().iterator();
            while (object.hasNext()) {
                ItemEntity e2 = (ItemEntity)object.next();
                ItemStack result = SpecialEquipmentEvents.process(player.m_9236_(), e2.m_32055_());
                e2.m_32045_(result);
            }
        }
        if ((object = event.getSource().m_7639_()) instanceof ServerPlayer && (player = (ServerPlayer)object).m_21205_().getEnchantmentLevel((Enchantment)LCEnchantments.ENDER.get()) > 0) {
            for (ItemEntity e2 : event.getDrops()) {
                EnderPickupEvent ender = new EnderPickupEvent((ServerPlayer)player, e2.m_32055_().m_41777_());
                MinecraftForge.EVENT_BUS.post((Event)ender);
                ItemStack stack = ender.getStack();
                if (!stack.m_41619_() && !player.m_150109_().m_36054_(stack)) {
                    e2.m_32045_(stack);
                    e2.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    continue;
                }
                e2.m_32045_(ItemStack.f_41583_);
            }
            event.getDrops().removeIf(e -> e.m_32055_().m_41619_());
        }
    }

    public static void dropExp(ServerLevel level, Vec3 pos, int exp, Operation<Void> original, @Nullable Player player) {
        if (player == null) {
            return;
        }
        if (player.m_21205_().getEnchantmentLevel((Enchantment)LCEnchantments.ENDER.get()) > 0) {
            pos = player.m_20182_();
        }
        original.call(new Object[]{level, pos, exp});
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity e;
        Stack<Pair<ServerPlayer, BlockState>> players = PLAYER.get();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)players.peek().getFirst();
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            e = (ItemEntity)entity;
            if (player.m_21205_().getEnchantmentLevel((Enchantment)LCEnchantments.SMELT.get()) > 0) {
                ItemStack result = SpecialEquipmentEvents.process(event.getLevel(), e.m_32055_());
                e.m_32045_(result);
            }
            if (player.m_21205_().getEnchantmentLevel((Enchantment)LCEnchantments.ENDER.get()) > 0) {
                EnderPickupEvent ender = new EnderPickupEvent(player, e.m_32055_().m_41777_());
                MinecraftForge.EVENT_BUS.post((Event)ender);
                ItemStack stack = ender.getStack();
                if (!stack.m_41619_() && !player.m_150109_().m_36054_(stack)) {
                    e.m_32045_(stack);
                    e.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                } else {
                    event.setCanceled(true);
                    return;
                }
            }
            if (player.m_213854_()) {
                e.getPersistentData().m_128379_("dampensVibrations", true);
            }
        }
        if ((entity = event.getEntity()) instanceof ExperienceOrb) {
            e = (ExperienceOrb)entity;
            if (player.m_21205_().getEnchantmentLevel((Enchantment)LCEnchantments.ENDER.get()) > 0) {
                player.f_36101_ = 0;
                e.m_6123_((Player)player);
                if (e.m_213877_()) {
                    event.setCanceled(true);
                    return;
                }
                e.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
            if (player.m_213854_()) {
                e.getPersistentData().m_128379_("dampensVibrations", true);
            }
        }
    }

    public static void pushPlayer(ServerPlayer player, BlockPos pos) {
        PLAYER.get().push((Pair<ServerPlayer, BlockState>)Pair.of((Object)player, (Object)player.m_9236_().m_8055_(pos)));
    }

    public static void popPlayer(ServerPlayer player) {
        if (PLAYER.get().peek().getFirst() == player) {
            PLAYER.get().pop();
        }
    }

    public static boolean canWalkOn(FluidState state, LivingEntity self) {
        if (state.m_76152_() == Fluids.f_76195_) {
            double dy = self.m_20186_();
            double vy = self.m_20184_().f_82480_;
            if (vy > 0.0 && dy - Math.floor(dy) < 0.5) {
                return false;
            }
            return EntityFeature.LAVA_WALKER.test(self);
        }
        return false;
    }

    public static boolean canSee(Entity instance, Operation<Boolean> original) {
        boolean ans = (Boolean)original.call(new Object[]{instance});
        if (ans) {
            return true;
        }
        if (instance instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)instance;
            if (le.m_20077_() && (EntityFeature.FIRE_REJECT.test(le) || EntityFeature.ENVIRONMENTAL_REJECT.test(le) || EntityFeature.LAVA_WALKER.test(le))) {
                return true;
            }
            if (le.f_146808_ && (PowderSnowBlock.m_154255_((Entity)instance) || EntityFeature.ENVIRONMENTAL_REJECT.test(le))) {
                return true;
            }
        }
        return false;
    }
}

